//
//  AHKABMainWindowController_Toolbar.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on Sat Feb 11 2006.
//  Copyright (c) 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKABMainWindowController.h"
#import "AHKABArrayController.h"

static NSString* 	AHKABToolbarIdentifier					= @"Address Utility Toolbar Identifier";

static NSString*	AHKToolbarNewItemIdentifier				= @"New Card Item Identifier";
static NSString*	AHKToolbarDeleteItemIdentifier			= @"Delete Card Item Identifier";
static NSString*	AHKToolbarInspectorItemIdentifier		= @"Inspector Item Identifier";
static NSString*	AHKToolbarSendItemIdentifier			= @"Send Item Identifier";
static NSString*	AHKToolbarReceiveItemIdentifier			= @"Receive Item Identifier";
static NSString*	AHKToolbarBookmarkUtilityItemIdentifier	= @"Bookmark Utility Item Identifier";
static NSString*	AHKToolbarFileUtilityItemIdentifier		= @"File Utility Item Identifier";
static NSString*	AHKToolbarMailUtilityItemIdentifier		= @"Mail Utility Item Identifier";
NSString*			AHKToolbarSearchItemIdentifier			= @"Search Item Identifier";

@implementation AHKABMainWindowController (Toolbar)

// this method is called in initialization process
- (void)setupToolbar
{
	NSToolbar *toolbar = [[NSToolbar alloc] initWithIdentifier:AHKABToolbarIdentifier];
    [toolbar setAllowsUserCustomization:YES];
    [toolbar setAutosavesConfiguration:YES];
    [toolbar setDisplayMode:NSToolbarDisplayModeIconAndLabel];
	[toolbar setDelegate:self];
	[[self window] setToolbar:toolbar];
	[toolbar release];
}

#pragma mark delegated method by NSToolbar
- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
	if ([itemIdentifier isEqual:AHKToolbarNewItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"New", @"AHKABLocalizable", @"toolbar.newCard.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"New Card", @"AHKABLocalizable", @"toolbar.newCard.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Add a new card.", @"AHKABLocalizable", @"toolbar.newCard.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarNewCardIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(insert:)];
	} else if ([itemIdentifier isEqual:AHKToolbarDeleteItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Delete", @"AHKABLocalizable", @"toolbar.delete.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Delete Card", @"AHKABLocalizable", @"toolbar.delete.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Delete selected card(s) from the list.", @"AHKABLocalizable", @"toolbar.delete.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarDeleteIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(delete:)];
	} else if ([itemIdentifier isEqual:AHKToolbarInspectorItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Inspector", @"AHKABLocalizable", @"toolbar.inspector.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Show Inspector", @"AHKABLocalizable", @"toolbar.inspector.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Show or hide inspector.", @"AHKABLocalizable", @"toolbar.inspector.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarShowInspectorIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(toggleInspector:)];
	} else if ([itemIdentifier isEqual:AHKToolbarReceiveItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Receive", @"AHKABLocalizable", @"toolbar.receive.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Receive from Kyopon", @"AHKABLocalizable", @"toolbar.receive.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Receive Data from Kyopon.", @"AHKABLocalizable", @"toolbar.receive.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarReceiveIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(receivePeople:)];
	} else if ([itemIdentifier isEqual:AHKToolbarSendItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Send", @"AHKABLocalizable", @"toolbar.send.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Send to Kyopon", @"AHKABLocalizable", @"toolbar.send.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Send Data to Kyopon.", @"AHKABLocalizable", @"toolbar.send.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarSendIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(sendPeople:)];
	} else if ([itemIdentifier isEqual:AHKToolbarBookmarkUtilityItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Bookmark Utility", @"AHKABLocalizable", @"toolbar.bookmarkUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Launch Bookmark Utility", @"AHKABLocalizable", @"toolbar.bookmarkUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Launch Kyopon Bookmark Utility.", @"AHKABLocalizable", @"toolbar.bookmarkUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarBookmarkUtilityIcon.tiff"]];
		//[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(launchBookmarkUtility:)];
	} else if ([itemIdentifier isEqual:AHKToolbarFileUtilityItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"File Utility", @"AHKABLocalizable", @"toolbar.fileUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Launch File Utility", @"AHKABLocalizable", @"toolbar.fileUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Launch Kyopon File Utility.", @"AHKABLocalizable", @"toolbar.fileUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarFileUtilityIcon.tiff"]];
		//[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(launchFileUtility:)];
	} else if ([itemIdentifier isEqual:AHKToolbarMailUtilityItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Mail Utility", @"AHKABLocalizable", @"toolbar.mailUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Launch Mail Utility", @"AHKABLocalizable", @"toolbar.mailUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Launch Kyopon Mail Utility.", @"AHKABLocalizable", @"toolbar.mailUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarMailUtilityIcon.tiff"]];
		//[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(launchMailUtility:)];
	} else if ([itemIdentifier isEqual:AHKToolbarSearchItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Search", @"AHKABLocalizable", @"toolbar.search.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Search", @"AHKABLocalizable", @"toolbar.search.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Show only cards containing the string specified.", @"AHKABLocalizable", @"toolbar.search.toolTip")];
		[toolbarItem setView:searchView];
		[toolbarItem setMinSize:NSMakeSize(60, NSHeight([searchView frame]))];
		[toolbarItem setMaxSize:NSMakeSize(210, NSHeight([searchView frame]))];
		//
		
	} else {
		toolbarItem = nil;
	}
	return toolbarItem;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
		AHKToolbarNewItemIdentifier,
		AHKToolbarDeleteItemIdentifier,
		NSToolbarSeparatorItemIdentifier,
		AHKToolbarInspectorItemIdentifier,
		NSToolbarSeparatorItemIdentifier,
		AHKToolbarReceiveItemIdentifier,
		AHKToolbarSendItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier,
		AHKToolbarSearchItemIdentifier,
		nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
		AHKToolbarNewItemIdentifier,
		AHKToolbarDeleteItemIdentifier,
		AHKToolbarInspectorItemIdentifier,
		AHKToolbarSearchItemIdentifier,
		//AHKToolbarImportVCardsItemIdentifier,
		//AHKToolbarImportFromAddressBookItemIdentifier,
		//AHKToolbarExportVCardsItemIdentifier,
		AHKToolbarReceiveItemIdentifier,
		AHKToolbarSendItemIdentifier,
		AHKToolbarBookmarkUtilityItemIdentifier,
		AHKToolbarFileUtilityItemIdentifier,
		AHKToolbarMailUtilityItemIdentifier,
		NSToolbarPrintItemIdentifier,
		//NSToolbarShowColorsItemIdentifier,
		//NSToolbarShowFontsItemIdentifier, 
		NSToolbarCustomizeToolbarItemIdentifier,
		NSToolbarSeparatorItemIdentifier, 
		NSToolbarSpaceItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier, 
		nil];
}

- (void)toolbarDidRemoveItem:(NSNotification *)notification
{
	NSToolbarItem *removedItem = [[notification userInfo] objectForKey:@"item"];
	if ([[removedItem itemIdentifier] isEqual:AHKToolbarSearchItemIdentifier]) {
		[self searchForString:@"" options:AHKABSearchAll];
	}
}

#pragma mark implementation of NSToolbarItemValidation
- (BOOL)validateToolbarItem:(NSToolbarItem *)theItem
{
	if ([theItem action] == @selector(add:)) {
		return [peopleController canAdd];
	} else if ([theItem action] == @selector(insert:)) {
		return [peopleController canInsert];
	} else if ([theItem action] == @selector(delete:)) {
		return [peopleController canRemove];
	
	} else if ([theItem action] == @selector(selectNext:)) {
		return [peopleController canSelectNext];
	} else if ([theItem action] == @selector(selectPrevious:)) {
		return [peopleController canSelectPrevious];
	} else if ([theItem action] == @selector(toggleInspector:)) {
		return YES;
	} else if ([theItem action] == @selector(exportVCards:)) {
		return ([[peopleController selectionIndexes] count] > 0);
	}
	return YES;
}


#pragma mark implementation for NSMenuValidation
- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem
{
	if ([menuItem action] == @selector(add:)) {
		return [peopleController canAdd];
	} else if ([menuItem action] == @selector(insert:)) {
		return [peopleController canInsert];
	} else if ([menuItem action] == @selector(delete:)) {
		return [peopleController canRemove];
	} else if ([menuItem action] == @selector(selectNext:)) {
		return [peopleController canSelectNext];
	} else if ([menuItem action] == @selector(selectPrevious:)) {
		return [peopleController canSelectPrevious];
		
	} else if ([menuItem action] == @selector(importVCards:) ||
			   [menuItem action] == @selector(importFromAddressBook:)) {
		return ([[peopleController content] count] < [peopleController capacity]);
		
	} else if ([menuItem action] == @selector(exportVCards:) ||
			   [menuItem action] == @selector(exportToAddressBook:)) {
		return ([[peopleController selectionIndexes] count] > 0);
		
	} else if ([menuItem action] == @selector(copy:)) {
		return ([peopleController selectionIndex] != NSNotFound);
	} else if ([menuItem action] == @selector(paste:)) {
		return ([[NSPasteboard generalPasteboard] availableTypeFromArray:[self acceptablePasteboardTypes]] != nil);
//		return YES;
	
	} else if ([menuItem action] == @selector(find:)) {
		return YES;
	
	} else if ([menuItem action] == @selector(toggleInspector:)) {
		NSDrawer *drawer = [[[self window] drawers] lastObject];
		if (drawer != nil) {
			if ([drawer state] == NSDrawerOpenState) {
				[menuItem setTitle:NSLocalizedStringFromTable(@"Hide Inspector", @"AHKABLocalizable", @"menuItem.hideInspector")];
			} else if ([drawer state] == NSDrawerClosedState) {
				[menuItem setTitle:NSLocalizedStringFromTable(@"Show Inspector", @"AHKABLocalizable", @"menuItem.showInspector")];
			}
		} else {
			if ([inspectorPanel isVisible]) {
				[menuItem setTitle:NSLocalizedStringFromTable(@"Hide Inspector", @"AHKABLocalizable", @"menuItem.hideInspector")];
			} else {
				[menuItem setTitle:NSLocalizedStringFromTable(@"Show Inspector", @"AHKABLocalizable", @"menuItem.showInspector")];
			}
		}
		return YES;
	} else if ([menuItem action] == @selector(renumberSelection:)) {
		return ([[peopleController selectionIndexes] count] > 1);
	} else if ([menuItem action] == @selector(deselectSort:)) {
		return ([[peopleController sortDescriptors] count] > 0);
		
	} else if ([menuItem action] == @selector(showWindow:)) {
		if ([[self window] isKeyWindow]) {
			[menuItem setState:NSOnState];
		} else {
			[menuItem setState:NSOffState];
		}
		return YES;
	}
	return YES;
}

@end
